/*=============================================================================}
{ This demo shows how to use Tags of items in mode when Tags are considered as }
{ pointers to dynamically allocated strings (PChar).                           }
{ In this demo, rvoTagsArePChars was added in Options (IMPORTANT!)             }
{ In this mode, you need to allocate memory for tag strings with StrNew.       }
{ RichView will free this memory itself when needed.                           }
{------------------------------------------------------------------------------}
{ The key methods are the same as in the previous demo.                        }
{ You still can use Add***, which set Tags to 0 (i.e. NULL - empty string).    }
{------------------------------------------------------------------------------}
{ This is the most powerfull method for organizing hypertext, because you can  }
{ encode any information that you need in string.                              }
{------------------------------------------------------------------------------}
{ IMPORTANT: Do not use #0 in Tag strings (except from the character closing   }
{ the string)                                                                  }
{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  RichView1->AddNLATag("Some text styles can be chosen as hypertext styles. ",0,0,0);
  RichView1->AddNLATag("Like this one.",4,-1, (int)StrNew("First_jump"));
  RichView1->AddNLATag(" You can have as many hypertext styles as you want.  ",0,-1,0);
  RichView1->AddNLATag("Here is one more.",5,-1,  (int)StrNew("Second_jump"));
  RichView1->AddNLATag("Images from Image Lists also can be hypertext: ",0,0,0);
  RichView1->AddHotspotExTag("Pen Image", 0,1, ImageList1, -1, (int)StrNew("Third_jump"));
  RichView1->AddNLATag(" Such images are called 'hotspots'.",0,-1,0);
  TIcon* ico = new TIcon;
  ico->Assign(Image1->Picture->Graphic);
  RichView1->AddHotPictureTag("Bobo", ico, -1, rvvaBaseline, (int)StrNew("Fourth_jump"));
  RichView1->Format();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichView1Jump(TObject *Sender, int id)
{
  int ItemNo;
  TCustomRVFormattedData* RVData;
  RichView1->GetJumpPointLocation(id, RVData, ItemNo);
  AnsiString Tag = (char*)RVData->GetItemTag(ItemNo);
  Panel1->Caption = "Clicked: Item with Tag="+Tag;
}
//---------------------------------------------------------------------------
